// --------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// --------------------------------------------------------------------
// Copyright (c) 2005 by Lattice Semiconductor Corporation
// --------------------------------------------------------------------
//
//
//                     Lattice Semiconductor Corporation
//                     5555 NE Moore Court
//                     Hillsboro, OR 97214
//                     U.S.A.
//
//                     TEL: 1-800-Lattice  (USA and Canada)
//                          1-408-826-6000 (other locations)
//
//                     web: http://www.latticesemi.com/
//                     email: techsupport@latticesemi.com
//
// --------------------------------------------------------------------
//
// Simulation Library File for ECP3
//
// $Header: 
//
`timescale 1ns / 1ps
module PDPW16KC (DI35, DI34, DI33, DI32, DI31, DI30, DI29, DI28, DI27,
         DI26, DI25, DI24, DI23, DI22, DI21, DI20, DI19, DI18,
         DI17, DI16, DI15, DI14, DI13, DI12, DI11, DI10, DI9,
         DI8, DI7, DI6, DI5, DI4, DI3, DI2, DI1, DI0,
         ADW8, ADW7, ADW6, ADW5, ADW4, ADW3, ADW2, ADW1, ADW0,
         BE3, BE2, BE1, BE0,
         CEW, CLKW, CSW2, CSW1, CSW0,
         ADR13, ADR12, ADR11, ADR10, ADR9, ADR8, ADR7, ADR6, ADR5,
         ADR4,  ADR3,  ADR2, ADR1, ADR0,
         CER, CLKR, CSR2, CSR1, CSR0, RST,
         DO35, DO34, DO33, DO32, DO31, DO30, DO29, DO28, DO27,
         DO26, DO25, DO24, DO23, DO22, DO21, DO20, DO19, DO18,
         DO17, DO16, DO15, DO14, DO13, DO12, DO11, DO10, DO9,
         DO8, DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0);

   parameter  DATA_WIDTH_W = 36;
   parameter  DATA_WIDTH_R = 18;
   parameter  REGMODE = "NOREG";
   parameter  CSDECODE_W = "0b000";
   parameter  CSDECODE_R = "0b000";
   parameter  GSR = "DISABLED";

parameter INITVAL_00 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_01 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_02 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_03 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_04 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_05 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_06 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_07 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_08 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_09 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_10 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_11 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_12 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_13 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_14 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_15 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_16 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_17 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_18 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_19 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";

input    DI35, DI34, DI33, DI32, DI31, DI30, DI29, DI28, DI27,
         DI26, DI25, DI24, DI23, DI22, DI21, DI20, DI19, DI18,
         DI17, DI16, DI15, DI14, DI13, DI12, DI11, DI10, DI9,
         DI8, DI7, DI6, DI5, DI4, DI3, DI2, DI1, DI0,
         ADW8, ADW7, ADW6, ADW5, ADW4, ADW3, ADW2, ADW1, ADW0,
         BE3, BE2, BE1, BE0,
         CEW, CLKW, CSW2, CSW1, CSW0,
         ADR13, ADR12, ADR11, ADR10, ADR9, ADR8, ADR7, ADR6, ADR5,
         ADR4,  ADR3,  ADR2, ADR1, ADR0,
         CER, CLKR, CSR2, CSR1, CSR0, RST;

output   DO35, DO34, DO33, DO32, DO31, DO30, DO29, DO28, DO27,
         DO26, DO25, DO24, DO23, DO22, DO21, DO20, DO19, DO18,
         DO17, DO16, DO15, DO14, DO13, DO12, DO11, DO10, DO9,
         DO8, DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0;

reg lo;
reg hi;

initial
begin
   lo = 1'b0;
   hi = 1'b1;
end

DP16KC EBR_INST (.DIA0(DI0), .DIA1(DI1), .DIA2(DI2), .DIA3(DI3), .DIA4(DI4),
       .DIA5(DI5), .DIA6(DI6), .DIA7(DI7), .DIA8(DI8), .DIA9(DI9), .DIA10(DI10), 
       .DIA11(DI11), .DIA12(DI12), .DIA13(DI13), .DIA14(DI14), .DIA15(DI15),
       .DIA16(DI16), .DIA17(DI17), .DIB0(DI18), .DIB1(DI19), .DIB2(DI20), .DIB3(DI21),
       .DIB4(DI22), .DIB5(DI23), .DIB6(DI24), .DIB7(DI25), .DIB8(DI26), .DIB9(DI27),
       .DIB10(DI28), .DIB11(DI29), .DIB12(DI30), .DIB13(DI31), .DIB14(DI32), .DIB15(DI33),
       .DIB16(DI34), .DIB17(DI35), .CEA(CEW), .CLKA(CLKW), .WEA(hi), .CSA0(CSW0), .CSA1(CSW1),
       .CSA2(CSW2), .RSTA(RST), .ADA0(BE0), .ADA1(BE1), .ADA2(BE2), .ADA3(BE3), .ADA4(lo),
       .ADA5(ADW0), .ADA6(ADW1), .ADA7(ADW2), .ADA8(ADW3), .ADA9(ADW4), .ADA10(ADW5),
       .ADA11(ADW6), .ADA12(ADW7), .ADA13(ADW8), .CEB(CER), .CLKB(CLKR), .WEB(lo),
       .CSB0(CSR0), .CSB1(CSR1), .CSB2(CSR2), .RSTB(RST), .ADB0(ADR0), .ADB1(ADR1), 
       .ADB2(ADR2), .ADB3(ADR3), .ADB4(ADR4), .ADB5(ADR5), .ADB6(ADR6), .ADB7(ADR7), 
       .ADB8(ADR8), .ADB9(ADR9), .ADB10(ADR10), .ADB11(ADR11), .ADB12(ADR12), .ADB13(ADR13),
       .OCEA(lo), .OCEB(CER),
       .DOB0(DO0), .DOB1(DO1), .DOB2(DO2), .DOB3(DO3), .DOB4(DO4), .DOB5(DO5), .DOB6(DO6), 
       .DOB7(DO7), .DOB8(DO8), .DOB9(DO9), .DOB10(DO10), .DOB11(DO11), .DOB12(DO12),
       .DOB13(DO13), .DOB14(DO14), .DOB15(DO15), .DOB16(DO16), .DOB17(DO17), .DOA0(DO18),
       .DOA1(DO19), .DOA2(DO20), .DOA3(DO21), .DOA4(DO22), .DOA5(DO23), .DOA6(DO24),
       .DOA7(DO25), .DOA8(DO26), .DOA9(DO27), .DOA10(DO28), .DOA11(DO29), .DOA12(DO30), 
       .DOA13(DO31), .DOA14(DO32), .DOA15(DO33), .DOA16(DO34), .DOA17(DO35));

defparam EBR_INST.DATA_WIDTH_A = 36;
defparam EBR_INST.DATA_WIDTH_B = DATA_WIDTH_R;
defparam EBR_INST.REGMODE_A = REGMODE;
defparam EBR_INST.REGMODE_B = REGMODE;
defparam EBR_INST.CSDECODE_A = CSDECODE_W;
defparam EBR_INST.CSDECODE_B = CSDECODE_R;
defparam EBR_INST.GSR = GSR;
defparam EBR_INST.INITVAL_00 = INITVAL_00;
defparam EBR_INST.INITVAL_01 = INITVAL_01;
defparam EBR_INST.INITVAL_02 = INITVAL_02;
defparam EBR_INST.INITVAL_03 = INITVAL_03;
defparam EBR_INST.INITVAL_04 = INITVAL_04;
defparam EBR_INST.INITVAL_05 = INITVAL_05;
defparam EBR_INST.INITVAL_06 = INITVAL_06;
defparam EBR_INST.INITVAL_07 = INITVAL_07;
defparam EBR_INST.INITVAL_08 = INITVAL_08;
defparam EBR_INST.INITVAL_09 = INITVAL_09;
defparam EBR_INST.INITVAL_0A = INITVAL_0A;
defparam EBR_INST.INITVAL_0B = INITVAL_0B;
defparam EBR_INST.INITVAL_0C = INITVAL_0C;
defparam EBR_INST.INITVAL_0D = INITVAL_0D;
defparam EBR_INST.INITVAL_0E = INITVAL_0E;
defparam EBR_INST.INITVAL_0F = INITVAL_0F;
defparam EBR_INST.INITVAL_10 = INITVAL_10;
defparam EBR_INST.INITVAL_11 = INITVAL_11;
defparam EBR_INST.INITVAL_12 = INITVAL_12;
defparam EBR_INST.INITVAL_13 = INITVAL_13;
defparam EBR_INST.INITVAL_14 = INITVAL_14;
defparam EBR_INST.INITVAL_15 = INITVAL_15;
defparam EBR_INST.INITVAL_16 = INITVAL_16;
defparam EBR_INST.INITVAL_17 = INITVAL_17;
defparam EBR_INST.INITVAL_18 = INITVAL_18;
defparam EBR_INST.INITVAL_19 = INITVAL_19;
defparam EBR_INST.INITVAL_1A = INITVAL_1A;
defparam EBR_INST.INITVAL_1B = INITVAL_1B;
defparam EBR_INST.INITVAL_1C = INITVAL_1C;
defparam EBR_INST.INITVAL_1D = INITVAL_1D;
defparam EBR_INST.INITVAL_1E = INITVAL_1E;
defparam EBR_INST.INITVAL_1F = INITVAL_1F;
defparam EBR_INST.INITVAL_20 = INITVAL_20;
defparam EBR_INST.INITVAL_21 = INITVAL_21;
defparam EBR_INST.INITVAL_22 = INITVAL_22;
defparam EBR_INST.INITVAL_23 = INITVAL_23;
defparam EBR_INST.INITVAL_24 = INITVAL_24;
defparam EBR_INST.INITVAL_25 = INITVAL_25;
defparam EBR_INST.INITVAL_26 = INITVAL_26;
defparam EBR_INST.INITVAL_27 = INITVAL_27;
defparam EBR_INST.INITVAL_28 = INITVAL_28;
defparam EBR_INST.INITVAL_29 = INITVAL_29;
defparam EBR_INST.INITVAL_2A = INITVAL_2A;
defparam EBR_INST.INITVAL_2B = INITVAL_2B;
defparam EBR_INST.INITVAL_2C = INITVAL_2C;
defparam EBR_INST.INITVAL_2D = INITVAL_2D;
defparam EBR_INST.INITVAL_2E = INITVAL_2E;
defparam EBR_INST.INITVAL_2F = INITVAL_2F;
defparam EBR_INST.INITVAL_30 = INITVAL_30;
defparam EBR_INST.INITVAL_31 = INITVAL_31;
defparam EBR_INST.INITVAL_32 = INITVAL_32;
defparam EBR_INST.INITVAL_33 = INITVAL_33;
defparam EBR_INST.INITVAL_34 = INITVAL_34;
defparam EBR_INST.INITVAL_35 = INITVAL_35;
defparam EBR_INST.INITVAL_36 = INITVAL_36;
defparam EBR_INST.INITVAL_37 = INITVAL_37;
defparam EBR_INST.INITVAL_38 = INITVAL_38;
defparam EBR_INST.INITVAL_39 = INITVAL_39;
defparam EBR_INST.INITVAL_3A = INITVAL_3A;
defparam EBR_INST.INITVAL_3B = INITVAL_3B;
defparam EBR_INST.INITVAL_3C = INITVAL_3C;
defparam EBR_INST.INITVAL_3D = INITVAL_3D;
defparam EBR_INST.INITVAL_3E = INITVAL_3E;
defparam EBR_INST.INITVAL_3F = INITVAL_3F;
 

endmodule
